package gov.va.med.mhv.vitals.converter;

import gov.va.med.mhv.vitals.dto.PulseOximetryReadingDTO;
import gov.va.med.mhv.vitals.model.PulseOximetryReading;

import java.util.ArrayList;
import java.util.List;

public class PulseOximetryConverter {
	
	public static PulseOximetryReadingDTO  convertPulseOximetryReadingDomain( PulseOximetryReading poReading ){
		PulseOximetryReadingDTO dto = new PulseOximetryReadingDTO();
		dto.setComments(poReading.getComments());
		dto.setOtherSymptoms(poReading.getOtherSymptoms());
		dto.setOximeterReading(poReading.getOximeterReading());
		dto.setOxygenSetting(poReading.getOxygenSetting());
		dto.setPulseOximetryId(poReading.getId());
		dto.setReading(poReading.getReading());
		dto.setRespiratoryRate(poReading.getRespiratoryRate());
		dto.setSuppOxygenDevice(poReading.getSuppOxygenDevice());
		dto.setSymptoms(poReading.getSymptoms());
		dto.setUserprofileId(poReading.getUserprofileId());
		return dto;
		
	}
	
	public static PulseOximetryReading convertPulseOXimetryReadingDTO(PulseOximetryReadingDTO poReadingDTO){
		PulseOximetryReading poReading = new PulseOximetryReading();
		poReading.setComments(poReadingDTO.getComments());
		poReading.setId(poReadingDTO.getPulseOximetryId());
		poReading.setOplock(0);
		poReading.setOtherSymptoms(poReadingDTO.getOtherSymptoms());
		poReading.setOximeterReading(poReadingDTO.getOximeterReading());
		poReading.setOxygenSetting(poReadingDTO.getOxygenSetting());
		poReading.setReading(poReadingDTO.getReading());
		poReading.setRespiratoryRate(poReadingDTO.getRespiratoryRate());
		poReading.setSuppOxygenDevice(poReadingDTO.getSuppOxygenDevice());
		poReading.setSymptoms(poReadingDTO.getSymptoms());
		poReading.setUserprofileId(poReadingDTO.getUserprofileId());
		return poReading;

		
	}
	
	public static List<PulseOximetryReadingDTO>  convertPulseOximetryReadings( List<PulseOximetryReading> poReadings ){
		List<PulseOximetryReadingDTO> poReadingDTOS = new ArrayList<PulseOximetryReadingDTO>();
		for(PulseOximetryReading poReading : poReadings){
			PulseOximetryReadingDTO dto = convertPulseOximetryReadingDomain(poReading);
			poReadingDTOS.add(dto);
		}
		return poReadingDTOS;
	}
}
